/* ***************************************************** **
   ch11_analytic_partitions_ordering_and_windows.sql
   
   Skrypt dla książki Praktyczna nauka SQL dla Oracle, Helion (2022),
   napisanej przez Kima Berga Hansena, https://www.kibeha.dk
   Używasz na własną odpowiedzialność.
   *****************************************************
   
   Rozdział 11.
   Klauzule partycjonowania oraz definiowania kolejności i okien
   
   Skrypt przeznaczony do wykonania w schemacie PRACTICAL
** ***************************************************** */

/* -----------------------------------------------------
   Konfiguracja formatowania sqlcl
   ----------------------------------------------------- */

set pagesize 80
set linesize 80
set sqlformat ansiconsole

/* -----------------------------------------------------
   Przykładowy kod do rozdziału 11.
   ----------------------------------------------------- */

-- Listing 11.1. Zawartość tabeli orderlines dla dwóch rodzajów piwa

select
   ol.product_id as p_id
 , p.name        as product_name
 , ol.order_id   as o_id
 , ol.qty
from orderlines ol
join products p
   on p.id = ol.product_id
where ol.product_id in (4280, 6600)
order by ol.product_id, ol.qty;

-- Listing 11.2. Przykład najprostszej funkcji analitycznej obliczającej sumę całkowitą

select
   ol.product_id as p_id
 , p.name        as product_name
 , ol.order_id   as o_id
 , ol.qty
 , sum(ol.qty) over () as t_qty
from orderlines ol
join products p
   on p.id = ol.product_id
where ol.product_id in (4280, 6600)
order by ol.product_id, ol.qty;

-- Listing 11.3. Obliczanie sum częściowych dla produktów z wykorzystaniem partycjonowania

select
   ol.product_id as p_id
 , p.name        as product_name
 , ol.order_id   as o_id
 , ol.qty
 , sum(ol.qty) over (
      partition by ol.product_id
   ) as p_qty
from orderlines ol
join products p
   on p.id = ol.product_id
where ol.product_id in (4280, 6600)
order by ol.product_id, ol.qty;

-- Listing 11.4. Obliczanie sumy bieżącej z użyciem kolejności i okien

select
   ol.product_id as p_id
 , p.name        as product_name
 , ol.order_id   as o_id
 , ol.qty
 , sum(ol.qty) over (
      order by ol.qty
      rows between unbounded preceding
               and current row
   ) as r_qty
from orderlines ol
join products p
   on p.id = ol.product_id
where ol.product_id in (4280, 6600)
order by ol.qty;

-- Możliwość zastosowania funkcji analitycznej w innej kolejności niż wskazują dane wyjściowe okazuje się w pewnych sytuacjach użyteczną techniką

select
   ol.product_id as p_id
 , p.name        as product_name
 , ol.order_id   as o_id
 , ol.qty
 , sum(ol.qty) over (
      order by ol.qty
      rows between unbounded preceding
               and current row
   ) as r_qty
from orderlines ol
join products p
   on p.id = ol.product_id
where ol.product_id in (4280, 6600)
order by ol.product_id, ol.qty;

-- Listing 11.5. Połączenie partycjonowania oraz definiowania kolejności i okna

select
   ol.product_id as p_id
 , p.name        as product_name
 , ol.order_id   as o_id
 , ol.qty
 , sum(ol.qty) over (
      partition by ol.product_id
      order by ol.qty
      rows between unbounded preceding
               and current row
   ) as p_qty
from orderlines ol
join products p
   on p.id = ol.product_id
where ol.product_id in (4280, 6600)
order by ol.product_id, ol.qty;

-- Listing 11.6. Okno obejmujące tylko wszystkie poprzednie rekordy

select
   ol.product_id as p_id
 , p.name        as product_name
 , ol.order_id   as o_id
 , ol.qty
 , sum(ol.qty) over (
      partition by ol.product_id
      order by ol.qty
      rows between unbounded preceding
               and 1 preceding
   ) as p_qty
from orderlines ol
join products p
   on p.id = ol.product_id
where ol.product_id in (4280, 6600)
order by ol.product_id, ol.qty;

-- Wygenerowanie odwrotnej sumy bieżącej

select
   ol.product_id as p_id
 , p.name        as product_name
 , ol.order_id   as o_id
 , ol.qty
 , sum(ol.qty) over (
      partition by ol.product_id
      order by ol.qty
      rows between current row
               and unbounded following
   ) as p_qty
from orderlines ol
join products p
   on p.id = ol.product_id
where ol.product_id in (4280, 6600)
order by ol.product_id, ol.qty;

-- Okno może dotyczyć jedynie wszystkich kolejnych rekordów

select
   ol.product_id as p_id
 , p.name        as product_name
 , ol.order_id   as o_id
 , ol.qty
 , sum(ol.qty) over (
      partition by ol.product_id
      order by ol.qty
      rows between 1 following
               and unbounded following
   ) as p_qty
from orderlines ol
join products p
   on p.id = ol.product_id
where ol.product_id in (4280, 6600)
order by ol.product_id, ol.qty;

-- Istnieje także możliwość wskazania oknu rekordu początkowego i końcowego do zsumowania

select
   ol.product_id as p_id
 , p.name        as product_name
 , ol.order_id   as o_id
 , ol.qty
 , sum(ol.qty) over (
      partition by ol.product_id
      order by ol.qty
      rows between 1 preceding
               and 1 following
   ) as p_qty
from orderlines ol
join products p
   on p.id = ol.product_id
where ol.product_id in (4280, 6600)
order by ol.product_id, ol.qty;

-- Ewentualnie okno może pozostać nieograniczone

select
   ol.product_id as p_id
 , p.name        as product_name
 , ol.order_id   as o_id
 , ol.qty
 , sum(ol.qty) over (
      partition by ol.product_id
      order by ol.qty
      rows between unbounded preceding
               and unbounded following
   ) as p_qty
from orderlines ol
join products p
   on p.id = ol.product_id
where ol.product_id in (4280, 6600)
order by ol.product_id, ol.qty;

-- Listing 11.7. Okno zdefiniowane na podstawie zakresu opartego na wartości qty

select
   ol.product_id as p_id
 , p.name        as product_name
 , ol.order_id   as o_id
 , ol.qty
 , sum(ol.qty) over (
      partition by ol.product_id
      order by ol.qty
      range between 20 preceding
                and 20 following
   ) as p_qty
from orderlines ol
join products p
   on p.id = ol.product_id
where ol.product_id in (4280, 6600)
order by ol.product_id, ol.qty;

-- Okno zdefiniowane na podstawie zakresu nie musi zawierać wartości rekordu bieżącego

select
   ol.product_id as p_id
 , p.name        as product_name
 , ol.order_id   as o_id
 , ol.qty
 , sum(ol.qty) over (
      partition by ol.product_id
      order by ol.qty
      range between  5 following
                and 25 following
   ) as p_qty
from orderlines ol
join products p
   on p.id = ol.product_id
where ol.product_id in (4280, 6600)
order by ol.product_id, ol.qty;

-- Suma bieżąca może być obliczana także dla okien zdefiniowanych na podstawie zakresu
 
select
   ol.product_id as p_id
 , p.name        as product_name
 , ol.order_id   as o_id
 , ol.qty
 , sum(ol.qty) over (
      partition by ol.product_id
      order by ol.qty
      range between unbounded preceding
                and current row
   ) as p_qty
from orderlines ol
join products p
   on p.id = ol.product_id
where ol.product_id in (4280, 6600)
order by ol.product_id, ol.qty;

-- Listing 11.8. Porównanie sum bieżących obliczonych za pomocą okien domyślnego, zakresu i rekordów

select
   ol.product_id as p_id
 , p.name        as product_name
 , ol.order_id   as o_id
 , ol.qty
 , sum(ol.qty) over (
      partition by ol.product_id
      order by ol.qty
      /* no window - rely on default */
   ) as def_q
 , sum(ol.qty) over (
      partition by ol.product_id
      order by ol.qty
      range between unbounded preceding
                and current row
   ) as range_q
 , sum(ol.qty) over (
      partition by ol.product_id
      order by ol.qty
      rows between unbounded preceding
               and current row
   ) as rows_q
from orderlines ol
join products p
   on p.id = ol.product_id
where ol.product_id in (4280, 6600)
order by ol.product_id, ol.qty;

-- Listing 11.9. Najlepsze praktyki zastosowane podczas obliczania sumy bieżącej
 
select
   ol.product_id as p_id
 , p.name        as product_name
 , ol.order_id   as o_id
 , ol.qty
 , sum(ol.qty) over (
      partition by ol.product_id
      order by ol.qty, ol.order_id
      rows between unbounded preceding
               and current row
   ) as p_qty
from orderlines ol
join products p
   on p.id = ol.product_id
where ol.product_id in (4280, 6600)
order by ol.product_id, ol.qty, ol.order_id;

/* ***************************************************** */
